/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonarqube.ws.client.WsRequest;

abstract class BaseRequest<SELF extends BaseRequest>
implements WsRequest {
    private final String path;
    private String mediaType = "application/json";
    private final Map<String, String> params = new LinkedHashMap<String, String>();

    BaseRequest(String path) {
        this.path = path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    public SELF setMediaType(String s) {
        Objects.requireNonNull(s, "media type of response cannot be null");
        this.mediaType = s;
        return (SELF)this;
    }

    public SELF setParam(String key, @Nullable Object value) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "a WS parameter key cannot be null");
        if (value != null) {
            this.params.put(key, value.toString());
        }
        return (SELF)this;
    }

    @Override
    public Map<String, String> getParams() {
        return this.params;
    }
}

